/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.shop;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import cz.insophy.inplan.property.Propertized;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.property.PropertyDefinitions;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Actiongram;
import cz.insophy.inplan.shop.CapabilityIsland;
import cz.insophy.inplan.shop.CapabilityIslands;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.MaterialQuantity;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.shop.RebuildType;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.util.Comparators;
import cz.insophy.inplan.util.HopcroftKarp;
import cz.insophy.inplan.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import javax.annotation.Nonnull;

public class ShopConfiguration {
    private final Map<String, Material> materials;
    private final Map<String, Product> products;
    private final Map<String, Material> matprods;
    private final List<Workplace> workplaces;
    private final Map<Class<? extends Propertized>, PropertyDefinitions> propdefs;
    private final ListMultimap<String, Workplace> capabilityMap;
    private final CapabilityIslands capabilityIslands;

    public ShopConfiguration(List<Workplace> workplaces, List<Material> matprods, Map<Class<? extends Propertized>, PropertyDefinitions> propdefs) {
        this.workplaces = Collections.unmodifiableList(workplaces);
        this.matprods = Maps.uniqueIndex(matprods, Material::getName);
        ArrayList<Material> materials = Lists.newArrayListWithCapacity(matprods.size() / 2);
        ArrayList<Product> products = Lists.newArrayListWithCapacity(matprods.size() / 2);
        ShopConfiguration.filterMatprods(matprods, materials, products);
        this.materials = Maps.uniqueIndex(materials, Material::getName);
        this.products = Maps.uniqueIndex(products, Material::getName);
        this.propdefs = propdefs;
        this.capabilityMap = MultimapBuilder.hashKeys().arrayListValues().build();
        this.buildCapMap();
        this.checkJoinedActions();
        this.checkRebuildMapping();
        this.capabilityIslands = CapabilityIslands.build(this);
    }

    private void checkRebuildMapping() {
        for (Product p : this.products.values()) {
            for (Actiongram ag : p.getActiongrams()) {
                for (Action a : ag.getActions()) {
                    for (Workplace wp : this.getWorkplaces(a.getCapabilityReq())) {
                        Preconditions.checkNotNull(wp.getRebuildType(a.getRebuildType()), "Invalid capreb mapping. %s.%s.%s@%s requests rt %s over cap %s", p.getName(), ag.getName(), a.getName(), wp.getName(), a.getRebuildType(), a.getCapabilityReq());
                    }
                }
            }
        }
    }

    private void buildCapMap() {
        for (Workplace wp : this.workplaces) {
            for (String cap : wp.getCapabilities()) {
                this.capabilityMap.put(cap, wp);
            }
        }
    }

    private void checkJoinedActions() {
        for (Product p : this.products.values()) {
            for (Actiongram ag : p.getActiongrams()) {
                this.checkJoinedActions(p, ag);
            }
        }
    }

    private void checkJoinedActions(Product p, Actiongram ag) {
        List<Action> actngram = ag.getActions();
        int n = actngram.size();
        if (n > 0 && actngram.get(n - 1).isJoinedWithFollowing()) {
            throw new IllegalArgumentException(String.format("Last action of %s %s cannot be joined.", p, ag));
        }
        int start = -1;
        for (int i = 0; i < n; ++i) {
            if (start == -1 && actngram.get(i).isJoinedWithFollowing()) {
                start = i;
                continue;
            }
            if (start < 0 || actngram.get(i).isJoinedWithFollowing()) continue;
            List<Action> group = actngram.subList(start, i + 1);
            HopcroftKarp<String, Workplace> hk = HopcroftKarp.create();
            for (Action a : group) {
                for (Workplace wpName : this.getWorkplaces(a.getCapabilityReq())) {
                    hk.addEdge(a.getName(), wpName);
                }
            }
            if (hk.run() != group.size()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Joined actions");
                for (Action a : group) {
                    sb.append(' ');
                    sb.append(a.getName());
                }
                sb.append(" of ");
                sb.append(p.getName());
                sb.append(' ');
                sb.append(ag.getName());
                sb.append(" have resource conflict.");
                throw new IllegalArgumentException(sb.toString());
            }
            start = -1;
        }
    }

    public Collection<Material> getMaterials() {
        return this.materials.values();
    }

    public Collection<Product> getProducts() {
        return this.products.values();
    }

    public Collection<Material> getMatprods() {
        return this.matprods.values();
    }

    public Material getMaterial(String name) {
        return this.materials.get(name);
    }

    public Material getMatprod(String name) {
        return this.matprods.get(name);
    }

    public Product getProduct(String name) {
        return this.products.get(name);
    }

    public List<Workplace> getWorkplaces() {
        return this.workplaces;
    }

    public List<Workplace> getWorkplaces(String capability) {
        return Collections.unmodifiableList(this.capabilityMap.get((Object)capability));
    }

    public Workplace getWorkplace(String name) {
        for (Workplace wp : this.workplaces) {
            if (!wp.getName().equals(name)) continue;
            return wp;
        }
        return null;
    }

    public Collection<RebuildType> getRebuildTypes() {
        Set<RebuildType> res = Sets.newIdentityHashSet();
        for (Workplace wp : this.workplaces) {
            res.addAll(wp.getRebuildTypes());
        }
        return res;
    }

    private static void filterMatprods(List<Material> mixed, List<Material> mats, List<Product> prods) {
        if (!mats.isEmpty() || !prods.isEmpty()) {
            throw new IllegalArgumentException("The passed lists of materials and products have to be empty");
        }
        for (Material matprod : mixed) {
            if (matprod instanceof Product) {
                prods.add((Product)matprod);
                continue;
            }
            mats.add(matprod);
        }
    }

    public PropertyDefinitions getPropertyDefinitionsInfoFor(Class<? extends Propertized> effectivity) {
        return this.propdefs.get(effectivity);
    }

    public Map<Class<? extends Propertized>, PropertyDefinitions> getPropdefs() {
        return ImmutableMap.copyOf(this.propdefs);
    }

    public Collection<PropertyDefinition> getPropertyDefinitionsFor(Class<? extends Propertized> effectivity) {
        return this.propdefs.get(effectivity).getPropertyDefinitions();
    }

    public Collection<PropertyDefinition> getPropertyDefinitions() {
        ArrayList<PropertyDefinition> pds = Lists.newArrayList();
        for (PropertyDefinitions propertyDefinitions : this.propdefs.values()) {
            pds.addAll(propertyDefinitions.getPropertyDefinitions());
        }
        return pds;
    }

    public PropertyDefinition getPropertyDefinition(Class<? extends Propertized> effectivity, String name) {
        if (!this.propdefs.containsKey(effectivity)) {
            return null;
        }
        PropertyDefinition res = null;
        for (PropertyDefinition pd : this.propdefs.get(effectivity).getPropertyDefinitions()) {
            if (!pd.getName().equals(name)) continue;
            res = pd;
            break;
        }
        return res;
    }

    public boolean isSemiproduct(Product suspect) {
        for (Product prod : this.products.values()) {
            for (Actiongram actgr : prod.getActiongrams()) {
                for (Action act : actgr.getActions()) {
                    for (MaterialQuantity mq : act.getBom().ingredients()) {
                        if (suspect != mq.getMaterial()) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public long getMaxRebuildTime(Workplace workplace) {
        Preconditions.checkArgument(this.workplaces.contains(workplace));
        return workplace.getMaxRebuildTime();
    }

    public long getMaxRebuildTime(Action action) {
        long maxTime = 0L;
        for (Workplace wp : this.getWorkplaces(action.getCapabilityReq())) {
            long time = wp.getRebuildType(action.getRebuildType()).getTime();
            if (time <= maxTime) continue;
            maxTime = time;
        }
        return maxTime;
    }

    public List<Product> getSortedProducts() {
        return ShopConfiguration.topoSortProductsCheck(this.products.values());
    }

    public static Tuple<List<Product>, Set<Product>> topoSortProducts(Collection<Product> prods) {
        return ShopConfiguration.topoSortProducts(prods, Collections.emptyList());
    }

    public static Tuple<List<Product>, Set<Product>> topoSortProducts(Collection<Product> prods, Collection<Tuple<Product, Product>> edges) {
        class ProdNode
        implements Comparable<ProdNode> {
            public final Product product;
            private final List<ProdNode> succs = Lists.newLinkedList();
            private int predCnt;
            public int level;

            private ProdNode(Product p) {
                this.product = p;
            }

            @Override
            public int compareTo(@Nonnull ProdNode o) {
                int res = Comparators.compare(this.level, o.level);
                if (res == 0) {
                    res = this.product.getName().compareTo(o.product.getName());
                }
                return res;
            }

            public String toString() {
                return MoreObjects.toStringHelper(this).add("level", this.level).add("product", this.product).add("predCnt", this.predCnt).toString();
            }
        }
        IdentityHashMap<Product, ProdNode> nodes = Maps.newIdentityHashMap();
        for (Product product : prods) {
            ProdNode node = new ProdNode(product);
            nodes.put(product, node);
        }
        for (ProdNode prodNode : nodes.values()) {
            for (Material m3 : prodNode.product.materials()) {
                if (!(m3 instanceof Product)) continue;
                ProdNode mpd = (ProdNode)nodes.get(m3);
                Preconditions.checkNotNull(mpd, "Incomplete set of products passed into topological sort. %s references non-existing %s.", (Object)prodNode.product.getName(), (Object)m3.getName());
                mpd.succs.add(prodNode);
                ++prodNode.predCnt;
            }
        }
        for (Tuple tuple : edges) {
            ProdNode pn = (ProdNode)nodes.get(tuple.getSecond());
            ProdNode mpd = (ProdNode)nodes.get(tuple.getFirst());
            String msg = "Additional edge product %s is not in the prods collection.";
            Preconditions.checkNotNull(pn, msg, tuple.getSecond());
            Preconditions.checkNotNull(mpd, msg, tuple.getFirst());
            mpd.succs.add(pn);
            ++pn.predCnt;
        }
        PriorityQueue<ProdNode> noPreds = Queues.newPriorityQueue();
        for (ProdNode pn : nodes.values()) {
            if (pn.predCnt != 0) continue;
            noPreds.add(pn);
        }
        for (ProdNode pn : noPreds) {
            nodes.remove(pn.product);
        }
        ArrayList<Product> arrayList = Lists.newArrayListWithCapacity(prods.size());
        while (!noPreds.isEmpty()) {
            ProdNode first = (ProdNode)noPreds.remove();
            arrayList.add(first.product);
            for (ProdNode pn : first.succs) {
                --pn.predCnt;
                if (pn.predCnt != 0) continue;
                pn.level = first.level + 1;
                noPreds.add(pn);
                nodes.remove(pn.product);
            }
        }
        return Tuple.create(arrayList, nodes.keySet());
    }

    public static List<Product> topoSortProductsCheck(Collection<Product> prods) {
        Tuple<List<Product>, Set<Product>> p = ShopConfiguration.topoSortProducts(prods, Collections.emptyList());
        Preconditions.checkState(p.getSecond().isEmpty(), "Cycle detected.");
        return p.getFirst();
    }

    public CapabilityIsland getIsland(String capability) {
        return this.capabilityIslands.getIsland(capability);
    }

    public CapabilityIsland getIsland(Workplace workplace) {
        return this.capabilityIslands.getIsland(workplace);
    }

    public List<CapabilityIsland> getIslands() {
        return this.capabilityIslands.getIslands();
    }
}

